"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMappings = void 0;
exports.getMappingsRoute = getMappingsRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getMappings = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      index
    } = request.body;
    const resp = await clusterClient.asScoped(request).asCurrentUser.indices.getMapping({
      index
    });
    return response.ok({
      body: {
        ok: true,
        resp
      }
    });
  } catch (err) {
    logger.error(`getMappings: ${err.stack}`);
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getMappings = getMappings;
function getMappingsRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.BASE_URI}/_mappings`,
    validate: {
      body: _configSchema.schema.object({
        index: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
      })
    }
  }, getMappings({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9lcnJvcnMiLCJfY29uc3RhbnRzIiwiZ2V0TWFwcGluZ3MiLCJjbHVzdGVyQ2xpZW50IiwibG9nZ2VyIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXNwb25zZSIsImluZGV4IiwiYm9keSIsInJlc3AiLCJhc1Njb3BlZCIsImFzQ3VycmVudFVzZXIiLCJpbmRpY2VzIiwiZ2V0TWFwcGluZyIsIm9rIiwiZXJyIiwiZXJyb3IiLCJzdGFjayIsImN1c3RvbUVycm9yIiwic2VydmVyRXJyb3IiLCJleHBvcnRzIiwiZ2V0TWFwcGluZ3NSb3V0ZSIsInJvdXRlciIsInBvc3QiLCJwYXRoIiwiQkFTRV9VUkkiLCJ2YWxpZGF0ZSIsInNjaGVtYSIsIm9iamVjdCIsIm9uZU9mIiwic3RyaW5nIiwiYXJyYXlPZiJdLCJzb3VyY2VzIjpbImdldF9tYXBwaW5ncy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogICAgQ29weXJpZ2h0IDIwMjAgZmxvcmFndW5uIEdtYkhcbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpO1xuICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuICogWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuICogZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuICogV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gKiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAa2JuL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgc2VydmVyRXJyb3IgfSBmcm9tICcuLi8uLi9saWIvZXJyb3JzJztcbmltcG9ydCB7IEJBU0VfVVJJIH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vY29tbW9uL3NpZ25hbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGNvbnN0IGdldE1hcHBpbmdzID0gKHsgY2x1c3RlckNsaWVudCwgbG9nZ2VyIH0pID0+IGFzeW5jIChjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSkgPT4ge1xuICB0cnkge1xuICAgIGNvbnN0IHsgaW5kZXggfSA9IHJlcXVlc3QuYm9keTtcblxuICAgIGNvbnN0IHJlc3AgPSBhd2FpdCBjbHVzdGVyQ2xpZW50XG4gICAgICAuYXNTY29wZWQocmVxdWVzdClcbiAgICAgIC5hc0N1cnJlbnRVc2VyLmluZGljZXMuZ2V0TWFwcGluZyh7IGluZGV4IH0pO1xuXG4gICAgcmV0dXJuIHJlc3BvbnNlLm9rKHsgYm9keTogeyBvazogdHJ1ZSwgcmVzcCB9IH0pO1xuICB9IGNhdGNoIChlcnIpIHtcbiAgICBsb2dnZXIuZXJyb3IoYGdldE1hcHBpbmdzOiAke2Vyci5zdGFja31gKTtcbiAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tRXJyb3Ioc2VydmVyRXJyb3IoZXJyKSk7XG4gIH1cbn07XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRNYXBwaW5nc1JvdXRlKHsgcm91dGVyLCBjbHVzdGVyQ2xpZW50LCBsb2dnZXIgfSkge1xuICByb3V0ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtCQVNFX1VSSX0vX21hcHBpbmdzYCxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIGJvZHk6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIGluZGV4OiBzY2hlbWEub25lT2YoW3NjaGVtYS5zdHJpbmcoKSwgc2NoZW1hLmFycmF5T2Yoc2NoZW1hLnN0cmluZygpKV0pLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBnZXRNYXBwaW5ncyh7IGNsdXN0ZXJDbGllbnQsIGxvZ2dlciB9KVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBZ0JBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLE9BQUEsR0FBQUQsT0FBQTtBQUNBLElBQUFFLFVBQUEsR0FBQUYsT0FBQTtBQWxCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBTU8sTUFBTUcsV0FBVyxHQUFHQSxDQUFDO0VBQUVDLGFBQWE7RUFBRUM7QUFBTyxDQUFDLEtBQUssT0FBT0MsT0FBTyxFQUFFQyxPQUFPLEVBQUVDLFFBQVEsS0FBSztFQUM5RixJQUFJO0lBQ0YsTUFBTTtNQUFFQztJQUFNLENBQUMsR0FBR0YsT0FBTyxDQUFDRyxJQUFJO0lBRTlCLE1BQU1DLElBQUksR0FBRyxNQUFNUCxhQUFhLENBQzdCUSxRQUFRLENBQUNMLE9BQU8sQ0FBQyxDQUNqQk0sYUFBYSxDQUFDQyxPQUFPLENBQUNDLFVBQVUsQ0FBQztNQUFFTjtJQUFNLENBQUMsQ0FBQztJQUU5QyxPQUFPRCxRQUFRLENBQUNRLEVBQUUsQ0FBQztNQUFFTixJQUFJLEVBQUU7UUFBRU0sRUFBRSxFQUFFLElBQUk7UUFBRUw7TUFBSztJQUFFLENBQUMsQ0FBQztFQUNsRCxDQUFDLENBQUMsT0FBT00sR0FBRyxFQUFFO0lBQ1paLE1BQU0sQ0FBQ2EsS0FBSyxDQUFFLGdCQUFlRCxHQUFHLENBQUNFLEtBQU0sRUFBQyxDQUFDO0lBQ3pDLE9BQU9YLFFBQVEsQ0FBQ1ksV0FBVyxDQUFDLElBQUFDLG1CQUFXLEVBQUNKLEdBQUcsQ0FBQyxDQUFDO0VBQy9DO0FBQ0YsQ0FBQztBQUFDSyxPQUFBLENBQUFuQixXQUFBLEdBQUFBLFdBQUE7QUFFSyxTQUFTb0IsZ0JBQWdCQSxDQUFDO0VBQUVDLE1BQU07RUFBRXBCLGFBQWE7RUFBRUM7QUFBTyxDQUFDLEVBQUU7RUFDbEVtQixNQUFNLENBQUNDLElBQUksQ0FDVDtJQUNFQyxJQUFJLEVBQUcsR0FBRUMsbUJBQVMsWUFBVztJQUM3QkMsUUFBUSxFQUFFO01BQ1JsQixJQUFJLEVBQUVtQixvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbEJyQixLQUFLLEVBQUVvQixvQkFBTSxDQUFDRSxLQUFLLENBQUMsQ0FBQ0Ysb0JBQU0sQ0FBQ0csTUFBTSxDQUFDLENBQUMsRUFBRUgsb0JBQU0sQ0FBQ0ksT0FBTyxDQUFDSixvQkFBTSxDQUFDRyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7TUFDeEUsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNEN0IsV0FBVyxDQUFDO0lBQUVDLGFBQWE7SUFBRUM7RUFBTyxDQUFDLENBQ3ZDLENBQUM7QUFDSCJ9